#!/usr/bin/env python
# encoding: utf-8

name = "H_Abstraction/TS_groups"
shortDesc = u""
longDesc = u"""

"""

entry(
    index = 1,
    label = "X_H_or_Xanyrad_H",
    group = "OR{H2, C_H, O_H}",
    distances = DistanceData(
        distances = {'d12': 1.33553, 'd13': 2.66604, 'd23': 1.33535},
        uncertainties = {'d12': 0.091092, 'd13': 0.067328, 'd23': 0.091248},
    ),
    shortDesc = u"""Fitted to 2142 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=30 label="OjH">]
[<Entry index=12 label="Cb_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=43 label="C_methane">, <Entry index=6 label="Hrad">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=27 label="OHH">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=4 label="C_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=11 label="Ct_H">, <Entry index=36 label="Cbj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=43 label="C_methane">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=3 label="H2">, <Entry index=65 label="OjCb">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
[<Entry index=4 label="C_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=3 label="H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=4 label="C_H">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=3 label="H2">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=27 label="OHH">, <Entry index=32 label="OjO">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=12 label="Cb_H">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=13 label="OradH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=30 label="OjH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=43 label="C_methane">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=12 label="Cb_H">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=32 label="OjO">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=79 label="CsCCHH">, <Entry index=6 label="Hrad">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=4 label="C_H">, <Entry index=32 label="OjO">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=4 label="C_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=27 label="OHH">, <Entry index=36 label="Cbj">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=30 label="OjH">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=4 label="C_H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=72 label="CtjC">]
[<Entry index=61 label="O/Cb/H">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 2,
    label = "Y_anyrad",
    group = "OR{Hrad, Orad, Crad}",
    distances = DistanceData(distances={}),
)

entry(
    index = 3,
    label = "H2",
    group = 
"""
1 *1 H u0 {2,S}
2 *2 H u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.342288, 'd13': -0.379376, 'd23': -0.039783},
        uncertainties = {'d12': 0.160362, 'd13': 0.100324, 'd23': 0.108062},
    ),
    shortDesc = u"""Fitted to 70 distances.
""",
    longDesc = 
u"""
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
[<Entry index=3 label="H2">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=62 label="OjCs">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=65 label="OjCb">]
[<Entry index=3 label="H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=3 label="H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=3 label="H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=3 label="H2">, <Entry index=36 label="Cbj">]
[<Entry index=3 label="H2">, <Entry index=30 label="OjH">]
[<Entry index=3 label="H2">, <Entry index=32 label="OjO">]
[<Entry index=3 label="H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 4,
    label = "C_H",
    group = 
"""
1 *1 C ux {2,S}
2 *2 H u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.029362, 'd13': 0.03372, 'd23': 0.004085},
        uncertainties = {'d12': 0.081461, 'd13': 0.063807, 'd23': 0.079603},
    ),
    shortDesc = u"""Fitted to 1832 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=12 label="Cb_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=43 label="C_methane">, <Entry index=6 label="Hrad">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=4 label="C_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=36 label="Cbj">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=11 label="Ct_H">, <Entry index=36 label="Cbj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=43 label="C_methane">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
[<Entry index=4 label="C_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=4 label="C_H">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=12 label="Cb_H">, <Entry index=6 label="Hrad">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=43 label="C_methane">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=12 label="Cb_H">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=79 label="CsCCHH">, <Entry index=6 label="Hrad">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=4 label="C_H">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=4 label="C_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=30 label="OjH">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=4 label="C_H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=72 label="CtjC">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 9,
    label = "Cs_H",
    group = 
"""
1 *1 Cs ux {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.013039, 'd13': 0.034846, 'd23': 0.020558},
        uncertainties = {'d12': 0.07199, 'd13': 0.055333, 'd23': 0.070136},
    ),
    shortDesc = u"""Fitted to 1304 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=47 label="C_methyl">, <Entry index=17 label="Cj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=43 label="C_methane">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=78 label="CsOHHH">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=47 label="C_methyl">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=43 label="C_methane">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 21,
    label = "Csnorad_H",
    group = 
"""
1 *1 Cs u0 {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.008578, 'd13': 0.034745, 'd23': 0.024975},
        uncertainties = {'d12': 0.070833, 'd13': 0.054023, 'd23': 0.070701},
    ),
    shortDesc = u"""Fitted to 1266 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=43 label="C_methane">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=43 label="C_methane">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 43,
    label = "C_methane",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
5    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.076977, 'd13': 0.025695, 'd23': -0.054808},
        uncertainties = {'d12': 0.069727, 'd13': 0.046007, 'd23': 0.0364},
    ),
    shortDesc = u"""Fitted to 69 distances.
""",
    longDesc = 
u"""
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=43 label="C_methane">, <Entry index=6 label="Hrad">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=43 label="C_methane">, <Entry index=17 label="Cj">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 44,
    label = "CsRHHH",
    group = 
"""
1 *1 Cs  u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H   u0 {1,S}
3    H   u0 {1,S}
4    H   u0 {1,S}
5    R!H ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.025708, 'd13': 0.02663, 'd23': -0.000824},
        uncertainties = {'d12': 0.067644, 'd13': 0.04335, 'd23': 0.054303},
    ),
    shortDesc = u"""Fitted to 684 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
""",
)

entry(
    index = 77,
    label = "CsCHHH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
5    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.025688, 'd13': 0.026803, 'd23': -0.001134},
        uncertainties = {'d12': 0.066673, 'd13': 0.043422, 'd23': 0.054173},
    ),
    shortDesc = u"""Fitted to 631 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
""",
)

entry(
    index = 118,
    label = "C/H3/Cs",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
5    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.050417, 'd13': 0.022318, 'd23': -0.030813},
        uncertainties = {'d12': 0.052797, 'd13': 0.040714, 'd23': 0.042237},
    ),
    shortDesc = u"""Fitted to 357 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
""",
)

entry(
    index = 119,
    label = "C/H3/Cd",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
5    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.016229, 'd13': 0.041314, 'd23': 0.054933},
        uncertainties = {'d12': 0.079824, 'd13': 0.045882, 'd23': 0.076326},
    ),
    shortDesc = u"""Fitted to 154 distances.
""",
    longDesc = 
u"""
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
""",
)

entry(
    index = 120,
    label = "C/H3/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.002891, 'd13': 0.026874, 'd23': 0.027628},
        uncertainties = {'d12': 0.092804, 'd13': 0.049837, 'd23': 0.057866},
    ),
    shortDesc = u"""Fitted to 36 distances.
""",
    longDesc = 
u"""
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
""",
)

entry(
    index = 121,
    label = "C/H3/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 78,
    label = "CsOHHH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.025956, 'd13': 0.024508, 'd23': 0.002967},
        uncertainties = {'d12': 0.08086, 'd13': 0.043917, 'd23': 0.057698},
    ),
    shortDesc = u"""Fitted to 53 distances.
""",
    longDesc = 
u"""
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
""",
)

entry(
    index = 45,
    label = "CsRRHH",
    group = 
"""
1 *1 Cs  u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H   u0 {1,S}
3    H   u0 {1,S}
4    R!H ux {1,S}
5    R!H ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.022947, 'd13': 0.048092, 'd23': 0.070377},
        uncertainties = {'d12': 0.075044, 'd13': 0.068352, 'd23': 0.094614},
    ),
    shortDesc = u"""Fitted to 409 distances.
""",
    longDesc = 
u"""
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
""",
)

entry(
    index = 79,
    label = "CsCCHH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    C  ux {1,S}
5    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.028156, 'd13': 0.050784, 'd23': 0.077681},
        uncertainties = {'d12': 0.07576, 'd13': 0.071919, 'd23': 0.097131},
    ),
    shortDesc = u"""Fitted to 356 distances.
""",
    longDesc = 
u"""
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
""",
)

entry(
    index = 122,
    label = "C/H2/Cs/Cs",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cs ux {1,S}
5    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.027797, 'd13': 0.019668, 'd23': -0.011348},
        uncertainties = {'d12': 0.087515, 'd13': 0.049771, 'd23': 0.060286},
    ),
    shortDesc = u"""Fitted to 73 distances.
""",
    longDesc = 
u"""
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
""",
)

entry(
    index = 123,
    label = "C/H2/Cs/Cd",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cs ux {1,S}
5    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.039272, 'd13': 0.05516, 'd23': 0.093747},
        uncertainties = {'d12': 0.080275, 'd13': 0.076392, 'd23': 0.108905},
    ),
    shortDesc = u"""Fitted to 143 distances.
""",
    longDesc = 
u"""
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
""",
)

entry(
    index = 124,
    label = "C/H2/Cs/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cs ux {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 125,
    label = "C/H2/Cs/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cs ux {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 126,
    label = "C/H2/Cd/Cd",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cd ux {1,S}
5    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.054862, 'd13': 0.070441, 'd23': 0.123563},
        uncertainties = {'d12': 0.070377, 'd13': 0.088161, 'd23': 0.110786},
    ),
    shortDesc = u"""Fitted to 99 distances.
""",
    longDesc = 
u"""
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 127,
    label = "C/H2/Cd/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cd ux {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 128,
    label = "C/H2/Cd/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cd ux {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 129,
    label = "C/H2/Ct/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Ct u0 {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 130,
    label = "C/H2/Ct/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Ct u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 131,
    label = "C/H2/Cb/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cb u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 80,
    label = "CsCOHH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    C  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.01123, 'd13': 0.030972, 'd23': 0.023228},
        uncertainties = {'d12': 0.072293, 'd13': 0.038597, 'd23': 0.078679},
    ),
    shortDesc = u"""Fitted to 51 distances.
""",
    longDesc = 
u"""
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
""",
)

entry(
    index = 132,
    label = "C/H2/Cs/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cs ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.013016, 'd13': 0.030315, 'd23': 0.020855},
        uncertainties = {'d12': 0.0725, 'd13': 0.038998, 'd23': 0.079142},
    ),
    shortDesc = u"""Fitted to 50 distances.
""",
    longDesc = 
u"""
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
""",
)

entry(
    index = 133,
    label = "C/H2/Cd/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cd ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.064825, 'd13': 0.058927, 'd23': 0.124233},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 134,
    label = "C/H2/Ct/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Ct u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 135,
    label = "C/H2/Cb/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cb u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 81,
    label = "CsOOHH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    O  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.027312, 'd13': 0.008337, 'd23': -0.01971},
        uncertainties = {'d12': 0.697245, 'd13': 0.107743, 'd23': 0.633001},
    ),
    shortDesc = u"""Fitted to 2 distances.
""",
    longDesc = 
u"""
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 46,
    label = "CsRRRH",
    group = 
"""
1 *1 Cs  u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H   u0 {1,S}
3    R!H ux {1,S}
4    R!H ux {1,S}
5    R!H ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.024248, 'd13': 0.041141, 'd23': 0.067372},
        uncertainties = {'d12': 0.078355, 'd13': 0.060817, 'd23': 0.076363},
    ),
    shortDesc = u"""Fitted to 104 distances.
""",
    longDesc = 
u"""
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
""",
)

entry(
    index = 82,
    label = "CsCCCH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    C  ux {1,S}
4    C  ux {1,S}
5    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.023913, 'd13': 0.041645, 'd23': 0.06756},
        uncertainties = {'d12': 0.078652, 'd13': 0.04847, 'd23': 0.068993},
    ),
    shortDesc = u"""Fitted to 103 distances.
""",
    longDesc = 
u"""
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
""",
)

entry(
    index = 136,
    label = "C/H/Cs/Cs/Cs",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
5    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.013473, 'd13': 0.029444, 'd23': 0.013732},
        uncertainties = {'d12': 0.151532, 'd13': 0.076775, 'd23': 0.088915},
    ),
    shortDesc = u"""Fitted to 15 distances.
""",
    longDesc = 
u"""
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 137,
    label = "C/H/Cs/Cs/Cd",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
5    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 138,
    label = "C/H/Cs/Cs/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 139,
    label = "C/H/Cs/Cs/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 140,
    label = "C/H/Cs/Cd/Cd",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cd ux {1,S}
5    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.121224, 'd13': 0.145531, 'd23': 0.263641},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
""",
)

entry(
    index = 141,
    label = "C/H/Cs/Cd/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cd ux {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 142,
    label = "C/H/Cs/Cd/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cd ux {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 143,
    label = "C/H/Cs/Ct/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Ct u0 {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 144,
    label = "C/H/Cs/Ct/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Ct u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 145,
    label = "C/H/Cs/Cb/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cb u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 146,
    label = "C/H/Cd/Cd/Cd",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
5    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 147,
    label = "C/H/Cd/Cd/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 148,
    label = "C/H/Cd/Cd/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 149,
    label = "C/H/Cd/Ct/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Ct u0 {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 150,
    label = "C/H/Cd/Ct/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Ct u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 151,
    label = "C/H/Cd/Cb/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cb u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 152,
    label = "C/H/Ct/Ct/Ct",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
5    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 153,
    label = "C/H/Ct/Ct/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 154,
    label = "C/H/Ct/Cb/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    Cb u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 155,
    label = "C/H/Cb/Cb/Cb",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
5    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 83,
    label = "CsCCOH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    C  ux {1,S}
4    C  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.121857, 'd13': -0.106079, 'd23': 0.012401},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
""",
)

entry(
    index = 156,
    label = "C/H/Cs/Cs/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.121857, 'd13': -0.106079, 'd23': 0.012401},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
""",
)

entry(
    index = 157,
    label = "C/H/Cs/Cd/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cd ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 158,
    label = "C/H/Cs/Ct/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Ct u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 159,
    label = "C/H/Cs/Cb/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cb u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 160,
    label = "C/H/Cd/Cd/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 161,
    label = "C/H/Cd/Ct/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Ct u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 162,
    label = "C/H/Cd/Cb/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cb u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 163,
    label = "C/H/Ct/Ct/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 164,
    label = "C/H/Ct/Cb/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    Cb u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 165,
    label = "C/H/Cb/Cb/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 84,
    label = "CsCOOH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    C  ux {1,S}
4    O  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 166,
    label = "C/H/Cs/O/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    O  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 167,
    label = "C/H/Cd/O/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    O  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 168,
    label = "C/H/Ct/O/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    O  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 169,
    label = "C/H/Cb/O/O",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
4    O  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 85,
    label = "CsOOOH",
    group = 
"""
1 *1 Cs u0 {2,S} {3,S} {4,S} {5,S}
2 *2 H  u0 {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
5    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 22,
    label = "Csrad_H",
    group = 
"""
1 *1 Cs u1 {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.154287, 'd13': 0.038063, 'd23': -0.119281},
        uncertainties = {'d12': 0.108246, 'd13': 0.092663, 'd23': 0.049991},
    ),
    shortDesc = u"""Fitted to 38 distances.
""",
    longDesc = 
u"""
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=6 label="Hrad">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=47 label="C_methyl">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 47,
    label = "C_methyl",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.154287, 'd13': 0.038063, 'd23': -0.119281},
        uncertainties = {'d12': 0.108246, 'd13': 0.092663, 'd23': 0.049991},
    ),
    shortDesc = u"""Fitted to 38 distances.
""",
    longDesc = 
u"""
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=6 label="Hrad">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=47 label="C_methyl">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 48,
    label = "CsradRH2",
    group = 
"""
1 *1 Cs  u1 {2,S} {3,S} {4,S}
2 *2 H   u0 {1,S}
3    H   u0 {1,S}
4    R!H ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 86,
    label = "CsradCHH",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 170,
    label = "Csrad/H/Cs/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 171,
    label = "Csrad/H/Cd/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 172,
    label = "Csrad/H/Ct/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 173,
    label = "Csrad/H/Cb/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 87,
    label = "CsradOH2",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 49,
    label = "CsradRRH",
    group = 
"""
1 *1 Cs  u1 {2,S} {3,S} {4,S}
2 *2 H   u0 {1,S}
3    R!H ux {1,S}
4    R!H ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 88,
    label = "CsradCCH",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    C  ux {1,S}
4    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 174,
    label = "Csrad/Cs/Cs/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 175,
    label = "Csrad/Cs/Cd/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 176,
    label = "Csrad/Cs/Ct/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 177,
    label = "Csrad/Cs/Cb/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 178,
    label = "Csrad/Cd/Cd/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 179,
    label = "Csrad/Cd/Ct/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 180,
    label = "Csrad/Cd/Cb/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 181,
    label = "Csrad/Ct/Ct/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 182,
    label = "Csrad/Ct/Cb/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 183,
    label = "Csrad/Cb/Cb/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 89,
    label = "CsradCOH",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    C  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 184,
    label = "Csrad/Cs/O/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 185,
    label = "Csrad/Cd/O/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 186,
    label = "Csrad/Ct/O/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 187,
    label = "Csrad/Cb/O/H",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 90,
    label = "CsradOOH",
    group = 
"""
1 *1 Cs u1 {2,S} {3,S} {4,S}
2 *2 H  u0 {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 23,
    label = "CsbiradH",
    group = "OR{Cs_singletH, Cs_tripletH}",
    distances = DistanceData(distances={}),
)

entry(
    index = 50,
    label = "Cs_singletH",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    R  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 91,
    label = "Cs_singletHH",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 92,
    label = "Cs_singletRH",
    group = 
"""
1 *1 Cs  u0 p1 {2,S} {3,S}
2 *2 H   u0 {1,S}
3    R!H ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 188,
    label = "C_singletCH",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 276,
    label = "C_singlet/Cs/H",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 277,
    label = "C_singlet/Cd/H",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 278,
    label = "C_singlet/Ct/H",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 279,
    label = "C_singlet/Cb/H",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 189,
    label = "C_singletOH",
    group = 
"""
1 *1 Cs u0 p1 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 51,
    label = "Cs_tripletH",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    R  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 93,
    label = "Cs_tripletHH",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 94,
    label = "Cs_tripletRH",
    group = 
"""
1 *1 Cs  u2 {2,S} {3,S}
2 *2 H   u0 {1,S}
3    R!H ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 190,
    label = "Cs_tripletCH",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 280,
    label = "C_triplet/Cs/H",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 281,
    label = "C_triplet/Cd/H",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 282,
    label = "C_triplet/Ct/H",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 283,
    label = "C_triplet/Cb/H",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 191,
    label = "Cs_tripletOH",
    group = 
"""
1 *1 Cs u2 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 24,
    label = "CstriradH",
    group = "OR{Cdoublet_H, Cquartet_H}",
    distances = DistanceData(distances={}),
)

entry(
    index = 52,
    label = "Cdoublet_H",
    group = 
"""
1 *1 C u1 p1 {2,S}
2 *2 H u0 p0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 53,
    label = "Cquartet_H",
    group = 
"""
1 *1 C u3 p0 {2,S}
2 *2 H u0 p0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 10,
    label = "Cd_H",
    group = 
"""
1 *1 Cd ux {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.080461, 'd13': 0.014535, 'd23': -0.066374},
        uncertainties = {'d12': 0.103756, 'd13': 0.079168, 'd23': 0.074386},
    ),
    shortDesc = u"""Fitted to 319 distances.
""",
    longDesc = 
u"""
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 25,
    label = "Cdnorad_H",
    group = 
"""
1 *1 Cd u0 {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.080461, 'd13': 0.014535, 'd23': -0.066374},
        uncertainties = {'d12': 0.103756, 'd13': 0.079168, 'd23': 0.074386},
    ),
    shortDesc = u"""Fitted to 319 distances.
""",
    longDesc = 
u"""
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 54,
    label = "Cd_C/R/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D}
2 *2 H  u0 {1,S}
3    C  ux {1,D}
""",
    distances = DistanceData(
        distances = {'d12': 0.080461, 'd13': 0.014535, 'd23': -0.066374},
        uncertainties = {'d12': 0.103756, 'd13': 0.079168, 'd23': 0.074386},
    ),
    shortDesc = u"""Fitted to 319 distances.
""",
    longDesc = 
u"""
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 95,
    label = "Cd_C/H2",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    C  ux {1,D}
4    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.075312, 'd13': 0.011806, 'd23': -0.063805},
        uncertainties = {'d12': 0.102529, 'd13': 0.07892, 'd23': 0.079636},
    ),
    shortDesc = u"""Fitted to 210 distances.
""",
    longDesc = 
u"""
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
""",
)

entry(
    index = 192,
    label = "Cd_Cds/H2",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,D}
4    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.112224, 'd13': 0.021864, 'd23': -0.091421},
        uncertainties = {'d12': 0.0956, 'd13': 0.08546, 'd23': 0.052588},
    ),
    shortDesc = u"""Fitted to 121 distances.
""",
    longDesc = 
u"""
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 193,
    label = "Cd_Cdd/H2",
    group = 
"""
1 *1 Cd  u0 {2,S} {3,D} {4,S}
2 *2 H   u0 {1,S}
3    Cdd u0 {1,D}
4    H   u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.024935, 'd13': -0.001921, 'd23': -0.026114},
        uncertainties = {'d12': 0.113205, 'd13': 0.070702, 'd23': 0.10727},
    ),
    shortDesc = u"""Fitted to 89 distances.
""",
    longDesc = 
u"""
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
""",
)

entry(
    index = 96,
    label = "Cd_C/C/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    C  ux {1,D}
4    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.090623, 'd13': 0.01992, 'd23': -0.071444},
        uncertainties = {'d12': 0.107737, 'd13': 0.080908, 'd23': 0.064262},
    ),
    shortDesc = u"""Fitted to 109 distances.
""",
    longDesc = 
u"""
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 194,
    label = "Cd_Cds/Cs/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,D}
4    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.065391, 'd13': 0.012283, 'd23': -0.049501},
        uncertainties = {'d12': 0.08552, 'd13': 0.071566, 'd23': 0.064639},
    ),
    shortDesc = u"""Fitted to 30 distances.
""",
    longDesc = 
u"""
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
""",
)

entry(
    index = 195,
    label = "Cd_Cds/Cd/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,D}
4    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.13302, 'd13': 0.030985, 'd23': -0.104743},
        uncertainties = {'d12': 0.138542, 'd13': 0.104188, 'd23': 0.077319},
    ),
    shortDesc = u"""Fitted to 53 distances.
""",
    longDesc = 
u"""
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
""",
)

entry(
    index = 196,
    label = "Cd_Cds/Ct/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,D}
4    Ct u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.031752, 'd13': 0.005788, 'd23': -0.027696},
        uncertainties = {'d12': 0.058956, 'd13': 0.026838, 'd23': 0.0353},
    ),
    shortDesc = u"""Fitted to 26 distances.
""",
    longDesc = 
u"""
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
""",
)

entry(
    index = 197,
    label = "Cd_Cds/Cb/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,D}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 198,
    label = "Cd_Cdd/Cs/H",
    group = 
"""
1 *1 Cd  u0 {2,S} {3,D} {4,S}
2 *2 H   u0 {1,S}
3    Cdd u0 {1,D}
4    Cs  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 199,
    label = "Cd_Cdd/Cd/H",
    group = 
"""
1 *1 Cd  u0 {2,S} {3,D} {4,S}
2 *2 H   u0 {1,S}
3    Cdd u0 {1,D}
4    Cd  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 200,
    label = "Cd_Cdd/Ct/H",
    group = 
"""
1 *1 Cd  u0 {2,S} {3,D} {4,S}
2 *2 H   u0 {1,S}
3    Cdd u0 {1,D}
4    Ct  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 201,
    label = "Cd_Cdd/Cb/H",
    group = 
"""
1 *1 Cd  u0 {2,S} {3,D} {4,S}
2 *2 H   u0 {1,S}
3    Cdd u0 {1,D}
4    Cb  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 97,
    label = "Cd_C/O/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    C  ux {1,D}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 202,
    label = "Cd_Cds/O/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,D}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 203,
    label = "Cd_Cdd/O/H",
    group = 
"""
1 *1 Cd  u0 {2,S} {3,D} {4,S}
2 *2 H   u0 {1,S}
3    Cdd ux {1,D}
4    O   ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 55,
    label = "Cd_O/R/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 98,
    label = "Cd_O/H2",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
4    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 99,
    label = "Cd_O/C/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
4    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 204,
    label = "Cd_O/Cs/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
4    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 205,
    label = "Cd_O/Cd/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
4    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 206,
    label = "Cd_O/Ct/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 207,
    label = "Cd_O/Cb/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 100,
    label = "Cd_O/O/H",
    group = 
"""
1 *1 Cd u0 {2,S} {3,D} {4,S}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 26,
    label = "Cdrad_H",
    group = 
"""
1 *1 Cd u1 {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 56,
    label = "Cdrad_C/H",
    group = 
"""
1 *1 Cd u1 {2,S} {3,D}
2 *2 H  u0 {1,S}
3    C  ux {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 101,
    label = "Cdrad_Cds/H",
    group = 
"""
1 *1 Cd u1 {2,S} {3,D}
2 *2 H  u0 {1,S}
3    Cd ux {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 102,
    label = "Cdrad_Cdd/H",
    group = 
"""
1 *1 Cd  u1 {2,S} {3,D}
2 *2 H   u0 {1,S}
3    Cdd u0 {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 57,
    label = "Cdrad_O/H",
    group = 
"""
1 *1 Cd u1 {2,S} {3,D}
2 *2 H  u0 {1,S}
3    O  u0 {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 11,
    label = "Ct_H",
    group = 
"""
1 *1 Ct u0 {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.431401, 'd13': 0.108762, 'd23': -0.229422},
        uncertainties = {'d12': 0.202232, 'd13': 0.200533, 'd23': 0.167522},
    ),
    shortDesc = u"""Fitted to 12 distances.
""",
    longDesc = 
u"""
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=11 label="Ct_H">, <Entry index=36 label="Cbj">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
""",
)

entry(
    index = 12,
    label = "Cb_H",
    group = 
"""
1 *1 Cb u0 {2,S}
2 *2 H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.117925, 'd13': 0.026137, 'd23': -0.092504},
        uncertainties = {'d12': 0.09239, 'd13': 0.078325, 'd23': 0.060839},
    ),
    shortDesc = u"""Fitted to 44 distances.
""",
    longDesc = 
u"""
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=72 label="CtjC">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=12 label="Cb_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=6 label="Hrad">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=30 label="OjH">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=12 label="Cb_H">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=32 label="OjO">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
""",
)

entry(
    index = 5,
    label = "O_H",
    group = 
"""
1 *1 O ux {2,S}
2 *2 H u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.118125, 'd13': -0.139931, 'd23': -0.018878},
        uncertainties = {'d12': 0.128368, 'd13': 0.081702, 'd23': 0.151653},
    ),
    shortDesc = u"""Fitted to 240 distances.
""",
    longDesc = 
u"""
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=30 label="OjH">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=27 label="OHH">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=61 label="O/Cb/H">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=13 label="OradH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=36 label="Cbj">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=17 label="Cj">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=27 label="OHH">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=27 label="OHH">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 13,
    label = "OradH",
    group = 
"""
1 *1 O u1 {2,S}
2 *2 H u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.075951, 'd13': -0.155556, 'd23': -0.082791},
        uncertainties = {'d12': 0.103966, 'd13': 0.034729, 'd23': 0.095151},
    ),
    shortDesc = u"""Fitted to 15 distances.
""",
    longDesc = 
u"""
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=13 label="OradH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
""",
)

entry(
    index = 14,
    label = "ORH",
    group = 
"""
1 *1 O u0 {2,S}
2 *2 H u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.121281, 'd13': -0.138762, 'd23': -0.014095},
        uncertainties = {'d12': 0.130475, 'd13': 0.084044, 'd23': 0.15517},
    ),
    shortDesc = u"""Fitted to 225 distances.
""",
    longDesc = 
u"""
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=30 label="OjH">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=27 label="OHH">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=61 label="O/Cb/H">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=36 label="Cbj">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=17 label="Cj">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=27 label="OHH">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=27 label="OHH">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 27,
    label = "OHH",
    group = 
"""
1 *1 O u0 {2,S} {3,S}
2 *2 H u0 {1,S}
3    H u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.070355, 'd13': -0.151526, 'd23': -0.189952},
        uncertainties = {'d12': 0.169282, 'd13': 0.171379, 'd23': 0.052065},
    ),
    shortDesc = u"""Fitted to 14 distances.
""",
    longDesc = 
u"""
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=27 label="OHH">, <Entry index=36 label="Cbj">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=27 label="OHH">, <Entry index=6 label="Hrad">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=27 label="OHH">, <Entry index=32 label="OjO">]
""",
)

entry(
    index = 28,
    label = "OCH",
    group = 
"""
1 *1 O u0 {2,S} {3,S}
2 *2 H u0 {1,S}
3    C ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.066073, 'd13': -0.160225, 'd23': -0.091363},
        uncertainties = {'d12': 0.086234, 'd13': 0.085236, 'd23': 0.07202},
    ),
    shortDesc = u"""Fitted to 52 distances.
""",
    longDesc = 
u"""
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=61 label="O/Cb/H">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
""",
)

entry(
    index = 58,
    label = "O/Cs/H",
    group = 
"""
1 *1 O  u0 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.064968, 'd13': -0.159202, 'd23': -0.091454},
        uncertainties = {'d12': 0.086953, 'd13': 0.067211, 'd23': 0.054152},
    ),
    shortDesc = u"""Fitted to 51 distances.
""",
    longDesc = 
u"""
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
""",
)

entry(
    index = 59,
    label = "O/Cd/H",
    group = 
"""
1 *1 O  u0 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 60,
    label = "O/Ct/H",
    group = 
"""
1 *1 O  u0 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 61,
    label = "O/Cb/H",
    group = 
"""
1 *1 O  u0 {2,S} {3,S}
2 *2 H  u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.234679, 'd13': -0.316172, 'd23': -0.077629},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=61 label="O/Cb/H">, <Entry index=6 label="Hrad">]
""",
)

entry(
    index = 29,
    label = "OOH",
    group = 
"""
1 *1 O u0 {2,S} {3,S}
2 *2 H u0 {1,S}
3    O ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.15601, 'd13': -0.130609, 'd23': 0.02651},
        uncertainties = {'d12': 0.141247, 'd13': 0.07596, 'd23': 0.180234},
    ),
    shortDesc = u"""Fitted to 159 distances.
""",
    longDesc = 
u"""
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=30 label="OjH">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=29 label="OOH">, <Entry index=32 label="OjO">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=29 label="OOH">, <Entry index=17 label="Cj">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
""",
)

entry(
    index = 6,
    label = "Hrad",
    group = 
"""
1 *3 H u1
""",
    distances = DistanceData(
        distances = {'d12': -0.039495, 'd13': -0.37919, 'd23': -0.342287},
        uncertainties = {'d12': 0.109745, 'd13': 0.100417, 'd23': 0.161572},
    ),
    shortDesc = u"""Fitted to 70 distances.
""",
    longDesc = 
u"""
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=6 label="Hrad">]
[<Entry index=12 label="Cb_H">, <Entry index=6 label="Hrad">]
[<Entry index=47 label="C_methyl">, <Entry index=6 label="Hrad">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=61 label="O/Cb/H">, <Entry index=6 label="Hrad">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=29 label="OOH">, <Entry index=6 label="Hrad">]
[<Entry index=82 label="CsCCCH">, <Entry index=6 label="Hrad">]
[<Entry index=58 label="O/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=6 label="Hrad">]
[<Entry index=43 label="C_methane">, <Entry index=6 label="Hrad">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=6 label="Hrad">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=6 label="Hrad">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=6 label="Hrad">]
[<Entry index=79 label="CsCCHH">, <Entry index=6 label="Hrad">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=77 label="CsCHHH">, <Entry index=6 label="Hrad">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=6 label="Hrad">]
[<Entry index=78 label="CsOHHH">, <Entry index=6 label="Hrad">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=6 label="Hrad">]
[<Entry index=156 label="C/H/Cs/Cs/O">, <Entry index=6 label="Hrad">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=6 label="Hrad">]
[<Entry index=4 label="C_H">, <Entry index=6 label="Hrad">]
[<Entry index=27 label="OHH">, <Entry index=6 label="Hrad">]
""",
)

entry(
    index = 7,
    label = "Orad",
    group = "OR{OjR, O_atom_triplet}",
    distances = DistanceData(
        distances = {'d12': -0.017829, 'd13': -0.139585, 'd23': -0.118668},
        uncertainties = {'d12': 0.151972, 'd13': 0.081633, 'd23': 0.128607},
    ),
    shortDesc = u"""Fitted to 240 distances.
""",
    longDesc = 
u"""
[<Entry index=12 label="Cb_H">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=4 label="C_H">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=3 label="H2">, <Entry index=65 label="OjCb">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=29 label="OOH">, <Entry index=30 label="OjH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=3 label="H2">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=29 label="OOH">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=12 label="Cb_H">, <Entry index=30 label="OjH">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=3 label="H2">, <Entry index=30 label="OjH">]
[<Entry index=3 label="H2">, <Entry index=32 label="OjO">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=4 label="C_H">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=27 label="OHH">, <Entry index=32 label="OjO">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
""",
)

entry(
    index = 15,
    label = "OjR",
    group = 
"""
1 *3 O u1 {2,S}
2    R ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.012844, 'd13': -0.138432, 'd23': -0.122031},
        uncertainties = {'d12': 0.155536, 'd13': 0.083971, 'd23': 0.130789},
    ),
    shortDesc = u"""Fitted to 225 distances.
""",
    longDesc = 
u"""
[<Entry index=12 label="Cb_H">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=4 label="C_H">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=29 label="OOH">, <Entry index=30 label="OjH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=3 label="H2">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=29 label="OOH">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=3 label="H2">, <Entry index=65 label="OjCb">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=12 label="Cb_H">, <Entry index=30 label="OjH">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=3 label="H2">, <Entry index=30 label="OjH">]
[<Entry index=3 label="H2">, <Entry index=32 label="OjO">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=4 label="C_H">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=27 label="OHH">, <Entry index=32 label="OjO">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
""",
)

entry(
    index = 30,
    label = "OjH",
    group = 
"""
1 *3 O u1 {2,S}
2    H u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.1933, 'd13': -0.149391, 'd23': 0.076164},
        uncertainties = {'d12': 0.048694, 'd13': 0.170393, 'd23': 0.166059},
    ),
    shortDesc = u"""Fitted to 14 distances.
""",
    longDesc = 
u"""
[<Entry index=29 label="OOH">, <Entry index=30 label="OjH">]
[<Entry index=3 label="H2">, <Entry index=30 label="OjH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=30 label="OjH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=30 label="OjH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=30 label="OjH">]
[<Entry index=12 label="Cb_H">, <Entry index=30 label="OjH">]
[<Entry index=43 label="C_methane">, <Entry index=30 label="OjH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=30 label="OjH">]
""",
)

entry(
    index = 31,
    label = "OjC",
    group = 
"""
1 *3 O u1 {2,S}
2    C ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.089279, 'd13': -0.160291, 'd23': -0.068097},
        uncertainties = {'d12': 0.07467, 'd13': 0.084887, 'd23': 0.089477},
    ),
    shortDesc = u"""Fitted to 52 distances.
""",
    longDesc = 
u"""
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=3 label="H2">, <Entry index=65 label="OjCb">]
[<Entry index=4 label="C_H">, <Entry index=62 label="OjCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=3 label="H2">, <Entry index=62 label="OjCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
""",
)

entry(
    index = 62,
    label = "OjCs",
    group = 
"""
1 *3 O  u1 {2,S}
2    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.089356, 'd13': -0.159249, 'd23': -0.066985},
        uncertainties = {'d12': 0.0577, 'd13': 0.066737, 'd23': 0.090235},
    ),
    shortDesc = u"""Fitted to 51 distances.
""",
    longDesc = 
u"""
[<Entry index=120 label="C/H3/Ct">, <Entry index=62 label="OjCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=62 label="OjCs">]
[<Entry index=47 label="C_methyl">, <Entry index=62 label="OjCs">]
[<Entry index=29 label="OOH">, <Entry index=62 label="OjCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=62 label="OjCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=62 label="OjCs">]
[<Entry index=4 label="C_H">, <Entry index=62 label="OjCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=62 label="OjCs">]
[<Entry index=3 label="H2">, <Entry index=62 label="OjCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=62 label="OjCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=62 label="OjCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=62 label="OjCs">]
[<Entry index=27 label="OHH">, <Entry index=62 label="OjCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=62 label="OjCs">]
[<Entry index=43 label="C_methane">, <Entry index=62 label="OjCs">]
""",
)

entry(
    index = 63,
    label = "OjCd",
    group = 
"""
1 *3 O  u1 {2,S}
2    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 64,
    label = "OjCt",
    group = 
"""
1 *3 O  u1 {2,S}
2    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 65,
    label = "OjCb",
    group = 
"""
1 *3 O  u1 {2,S}
2    Cb u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.077813, 'd13': -0.316079, 'd23': -0.234351},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=3 label="H2">, <Entry index=65 label="OjCb">]
""",
)

entry(
    index = 32,
    label = "OjO",
    group = 
"""
1 *3 O u1 {2,S}
2    O ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.027899, 'd13': -0.130319, 'd23': -0.156949},
        uncertainties = {'d12': 0.18041, 'd13': 0.076118, 'd23': 0.141294},
    ),
    shortDesc = u"""Fitted to 159 distances.
""",
    longDesc = 
u"""
[<Entry index=79 label="CsCCHH">, <Entry index=32 label="OjO">]
[<Entry index=77 label="CsCHHH">, <Entry index=32 label="OjO">]
[<Entry index=4 label="C_H">, <Entry index=32 label="OjO">]
[<Entry index=82 label="CsCCCH">, <Entry index=32 label="OjO">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=32 label="OjO">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=32 label="OjO">]
[<Entry index=47 label="C_methyl">, <Entry index=32 label="OjO">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=58 label="O/Cs/H">, <Entry index=32 label="OjO">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=32 label="OjO">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=32 label="OjO">]
[<Entry index=29 label="OOH">, <Entry index=32 label="OjO">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=32 label="OjO">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=32 label="OjO">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=32 label="OjO">]
[<Entry index=43 label="C_methane">, <Entry index=32 label="OjO">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=32 label="OjO">]
[<Entry index=78 label="CsOHHH">, <Entry index=32 label="OjO">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=32 label="OjO">]
[<Entry index=3 label="H2">, <Entry index=32 label="OjO">]
[<Entry index=12 label="Cb_H">, <Entry index=32 label="OjO">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=32 label="OjO">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=32 label="OjO">]
[<Entry index=27 label="OHH">, <Entry index=32 label="OjO">]
""",
)

entry(
    index = 16,
    label = "O_atom_triplet",
    group = 
"""
1 *3 O u2
""",
    distances = DistanceData(
        distances = {'d12': -0.083286, 'd13': -0.154718, 'd23': -0.074511},
        uncertainties = {'d12': 0.094109, 'd13': 0.03484, 'd23': 0.102428},
    ),
    shortDesc = u"""Fitted to 15 distances.
""",
    longDesc = 
u"""
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=78 label="CsOHHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=79 label="CsCCHH">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=43 label="C_methane">, <Entry index=16 label="O_atom_triplet">]
[<Entry index=77 label="CsCHHH">, <Entry index=16 label="O_atom_triplet">]
""",
)

entry(
    index = 8,
    label = "Crad",
    group = 
"""
1 *3 C u[1,2,3,4]
""",
    distances = DistanceData(
        distances = {'d12': 0.003965, 'd13': 0.033918, 'd23': 0.029654},
        uncertainties = {'d12': 0.079232, 'd13': 0.063813, 'd23': 0.081528},
    ),
    shortDesc = u"""Fitted to 1832 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=4 label="C_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=36 label="Cbj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
[<Entry index=4 label="C_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=3 label="H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=4 label="C_H">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=13 label="OradH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=43 label="C_methane">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=4 label="C_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=27 label="OHH">, <Entry index=36 label="Cbj">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=4 label="C_H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=72 label="CtjC">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 17,
    label = "Cj",
    group = 
"""
1 *3 C u1
""",
    distances = DistanceData(
        distances = {'d12': 0.006693, 'd13': 0.033836, 'd23': 0.026902},
        uncertainties = {'d12': 0.079772, 'd13': 0.063194, 'd23': 0.080986},
    ),
    shortDesc = u"""Fitted to 1794 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=4 label="C_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=36 label="Cbj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=3 label="H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=4 label="C_H">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=17 label="Cj">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=17 label="Cj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=17 label="Cj">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=17 label="Cj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=13 label="OradH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=43 label="C_methane">, <Entry index=17 label="Cj">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=4 label="C_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=17 label="Cj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=17 label="Cj">]
[<Entry index=4 label="C_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=17 label="Cj">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=4 label="C_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=36 label="Cbj">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=17 label="Cj">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=27 label="OHH">, <Entry index=36 label="Cbj">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=17 label="Cj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=17 label="Cj">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=17 label="Cj">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=17 label="Cj">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=72 label="CtjC">]
[<Entry index=79 label="CsCCHH">, <Entry index=17 label="Cj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
""",
)

entry(
    index = 33,
    label = "Csj",
    group = 
"""
1 *3 Cs u1
""",
    distances = DistanceData(
        distances = {'d12': 0.025234, 'd13': 0.034738, 'd23': 0.00838},
        uncertainties = {'d12': 0.071352, 'd13': 0.054225, 'd23': 0.07136},
    ),
    shortDesc = u"""Fitted to 1266 distances.
""",
    longDesc = 
u"""
[<Entry index=4 label="C_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=3 label="H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=3 label="H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=4 label="C_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=13 label="OradH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=3 label="H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=4 label="C_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 66,
    label = "Cs_methyl",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
4    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.053769, 'd13': 0.025074, 'd23': 0.075442},
        uncertainties = {'d12': 0.037203, 'd13': 0.045929, 'd23': 0.071816},
    ),
    shortDesc = u"""Fitted to 69 distances.
""",
    longDesc = 
u"""
[<Entry index=119 label="C/H3/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=66 label="Cs_methyl">]
[<Entry index=29 label="OOH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=82 label="CsCCCH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=79 label="CsCCHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=12 label="Cb_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=66 label="Cs_methyl">]
[<Entry index=4 label="C_H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=78 label="CsOHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=77 label="CsCHHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=27 label="OHH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=3 label="H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=66 label="Cs_methyl">]
[<Entry index=13 label="OradH">, <Entry index=66 label="Cs_methyl">]
[<Entry index=58 label="O/Cs/H">, <Entry index=66 label="Cs_methyl">]
[<Entry index=140 label="C/H/Cs/Cd/Cd">, <Entry index=66 label="Cs_methyl">]
[<Entry index=81 label="CsOOHH">, <Entry index=66 label="Cs_methyl">]
""",
)

entry(
    index = 67,
    label = "CsjRH2",
    group = 
"""
1 *3 Cs  u1 {2,S} {3,S} {4,S}
2    H   u0 {1,S}
3    H   u0 {1,S}
4    R!H ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.00076, 'd13': 0.026698, 'd23': 0.025831},
        uncertainties = {'d12': 0.055039, 'd13': 0.043564, 'd23': 0.06831},
    ),
    shortDesc = u"""Fitted to 684 distances.
""",
    longDesc = 
u"""
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=4 label="C_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=4 label="C_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 103,
    label = "CsjCH2",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
4    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.001101, 'd13': 0.026859, 'd23': 0.025831},
        uncertainties = {'d12': 0.054905, 'd13': 0.043647, 'd23': 0.067348},
    ),
    shortDesc = u"""Fitted to 631 distances.
""",
    longDesc = 
u"""
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=103 label="CsjCH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=4 label="C_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=103 label="CsjCH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=103 label="CsjCH2">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=103 label="CsjCH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=103 label="CsjCH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=103 label="CsjCH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=43 label="C_methane">, <Entry index=103 label="CsjCH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=13 label="OradH">, <Entry index=103 label="CsjCH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 208,
    label = "Csj/Cs/H2",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
4    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.031137, 'd13': 0.022282, 'd23': 0.050803},
        uncertainties = {'d12': 0.043022, 'd13': 0.040975, 'd23': 0.053803},
    ),
    shortDesc = u"""Fitted to 357 distances.
""",
    longDesc = 
u"""
[<Entry index=119 label="C/H3/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=29 label="OOH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=81 label="CsOOHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=133 label="C/H2/Cd/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=4 label="C_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=3 label="H2">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=27 label="OHH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=13 label="OradH">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=43 label="C_methane">, <Entry index=208 label="Csj/Cs/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=208 label="Csj/Cs/H2">]
""",
)

entry(
    index = 209,
    label = "Csj/Cd/H2",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.055474, 'd13': 0.041386, 'd23': -0.016532},
        uncertainties = {'d12': 0.076806, 'd13': 0.046109, 'd23': 0.080072},
    ),
    shortDesc = u"""Fitted to 154 distances.
""",
    longDesc = 
u"""
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=3 label="H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=43 label="C_methane">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=29 label="OOH">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=4 label="C_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=11 label="Ct_H">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=209 label="Csj/Cd/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=209 label="Csj/Cd/H2">]
""",
)

entry(
    index = 210,
    label = "Csj/Ct/H2",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.028053, 'd13': 0.027161, 'd23': -0.002911},
        uncertainties = {'d12': 0.059139, 'd13': 0.050091, 'd23': 0.093378},
    ),
    shortDesc = u"""Fitted to 36 distances.
""",
    longDesc = 
u"""
[<Entry index=119 label="C/H3/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=29 label="OOH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=82 label="CsCCCH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=47 label="C_methyl">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=78 label="CsOHHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=3 label="H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=79 label="CsCCHH">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=4 label="C_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=12 label="Cb_H">, <Entry index=210 label="Csj/Ct/H2">]
[<Entry index=77 label="CsCHHH">, <Entry index=210 label="Csj/Ct/H2">]
""",
)

entry(
    index = 211,
    label = "Csj/Cb/H2",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 104,
    label = "CsjOH2",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.003401, 'd13': 0.024741, 'd23': 0.025833},
        uncertainties = {'d12': 0.05851, 'd13': 0.043998, 'd23': 0.081464},
    ),
    shortDesc = u"""Fitted to 53 distances.
""",
    longDesc = 
u"""
[<Entry index=79 label="CsCCHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=12 label="Cb_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=104 label="CsjOH2">]
[<Entry index=13 label="OradH">, <Entry index=104 label="CsjOH2">]
[<Entry index=43 label="C_methane">, <Entry index=104 label="CsjOH2">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=29 label="OOH">, <Entry index=104 label="CsjOH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=104 label="CsjOH2">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=104 label="CsjOH2">]
[<Entry index=3 label="H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=4 label="C_H">, <Entry index=104 label="CsjOH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=104 label="CsjOH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=47 label="C_methyl">, <Entry index=104 label="CsjOH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=104 label="CsjOH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=104 label="CsjOH2">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=104 label="CsjOH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=104 label="CsjOH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=104 label="CsjOH2">]
""",
)

entry(
    index = 68,
    label = "CsjRRH",
    group = 
"""
1 *3 Cs  u1 {2,S} {3,S} {4,S}
2    H   u0 {1,S}
3    R!H ux {1,S}
4    R!H ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.070627, 'd13': 0.048156, 'd23': -0.02316},
        uncertainties = {'d12': 0.095265, 'd13': 0.068554, 'd23': 0.075171},
    ),
    shortDesc = u"""Fitted to 409 distances.
""",
    longDesc = 
u"""
[<Entry index=4 label="C_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=3 label="H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 105,
    label = "CsjCCH",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    C  ux {1,S}
4    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.077902, 'd13': 0.050848, 'd23': -0.028338},
        uncertainties = {'d12': 0.097832, 'd13': 0.07213, 'd23': 0.075893},
    ),
    shortDesc = u"""Fitted to 356 distances.
""",
    longDesc = 
u"""
[<Entry index=4 label="C_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=105 label="CsjCCH">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=3 label="H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=105 label="CsjCCH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=105 label="CsjCCH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=29 label="OOH">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=105 label="CsjCCH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=77 label="CsCHHH">, <Entry index=105 label="CsjCCH">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=13 label="OradH">, <Entry index=105 label="CsjCCH">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=105 label="CsjCCH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=11 label="Ct_H">, <Entry index=105 label="CsjCCH">]
[<Entry index=43 label="C_methane">, <Entry index=105 label="CsjCCH">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 212,
    label = "Csj/Cs/Cs/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.011458, 'd13': 0.019955, 'd23': 0.028261},
        uncertainties = {'d12': 0.060529, 'd13': 0.049709, 'd23': 0.087951},
    ),
    shortDesc = u"""Fitted to 73 distances.
""",
    longDesc = 
u"""
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=43 label="C_methane">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=12 label="Cb_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=13 label="OradH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=4 label="C_H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=3 label="H2">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=29 label="OOH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=47 label="C_methyl">, <Entry index=212 label="Csj/Cs/Cs/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=212 label="Csj/Cs/Cs/H">]
""",
)

entry(
    index = 213,
    label = "Csj/Cs/Cd/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cs ux {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.094158, 'd13': 0.055281, 'd23': -0.039761},
        uncertainties = {'d12': 0.109661, 'd13': 0.07669, 'd23': 0.080228},
    ),
    shortDesc = u"""Fitted to 143 distances.
""",
    longDesc = 
u"""
[<Entry index=29 label="OOH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=11 label="Ct_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=47 label="C_methyl">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=213 label="Csj/Cs/Cd/H">]
""",
)

entry(
    index = 214,
    label = "Csj/Cs/Ct/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cs ux {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 215,
    label = "Csj/Cs/Cb/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cs ux {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 216,
    label = "Csj/Cd/Cd/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.124292, 'd13': 0.070403, 'd23': -0.055524},
        uncertainties = {'d12': 0.111507, 'd13': 0.088415, 'd23': 0.070259},
    ),
    shortDesc = u"""Fitted to 99 distances.
""",
    longDesc = 
u"""
[<Entry index=47 label="C_methyl">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=3 label="H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=12 label="Cb_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=29 label="OOH">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=4 label="C_H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=43 label="C_methane">, <Entry index=216 label="Csj/Cd/Cd/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=216 label="Csj/Cd/Cd/H">]
""",
)

entry(
    index = 217,
    label = "Csj/Cd/Ct/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cd ux {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 218,
    label = "Csj/Cd/Cb/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cd ux {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 219,
    label = "Csj/Ct/Ct/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 220,
    label = "Csj/Ct/Cb/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Ct u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 221,
    label = "Csj/Cb/Cb/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 106,
    label = "CsjCOH",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    C  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.024012, 'd13': 0.031199, 'd23': 0.0106},
        uncertainties = {'d12': 0.078723, 'd13': 0.038717, 'd23': 0.072169},
    ),
    shortDesc = u"""Fitted to 51 distances.
""",
    longDesc = 
u"""
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
""",
)

entry(
    index = 222,
    label = "Csj/Cs/O/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cs ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.021572, 'd13': 0.030539, 'd23': 0.012445},
        uncertainties = {'d12': 0.079138, 'd13': 0.039119, 'd23': 0.072313},
    ),
    shortDesc = u"""Fitted to 50 distances.
""",
    longDesc = 
u"""
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=43 label="C_methane">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=79 label="CsCCHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=77 label="CsCHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=58 label="O/Cs/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=29 label="OOH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=12 label="Cb_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=82 label="CsCCCH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=3 label="H2">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=78 label="CsOHHH">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=4 label="C_H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=47 label="C_methyl">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=222 label="Csj/Cs/O/H">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=222 label="Csj/Cs/O/H">]
""",
)

entry(
    index = 223,
    label = "Csj/Cd/O/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cd ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.126136, 'd13': 0.058822, 'd23': -0.066634},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=223 label="Csj/Cd/O/H">]
""",
)

entry(
    index = 224,
    label = "Csj/Ct/O/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Ct u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 225,
    label = "Csj/Cb/O/H",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    Cb u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 107,
    label = "CsjOOH",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    H  u0 {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.017641, 'd13': 0.008156, 'd23': 0.025276},
        uncertainties = {'d12': 0.683395, 'd13': 0.112506, 'd23': 0.740579},
    ),
    shortDesc = u"""Fitted to 2 distances.
""",
    longDesc = 
u"""
[<Entry index=43 label="C_methane">, <Entry index=107 label="CsjOOH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=107 label="CsjOOH">]
""",
)

entry(
    index = 69,
    label = "CsjRRR",
    group = 
"""
1 *3 Cs  u1 {2,S} {3,S} {4,S}
2    R!H ux {1,S}
3    R!H ux {1,S}
4    R!H ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.068516, 'd13': 0.040796, 'd23': -0.025639},
        uncertainties = {'d12': 0.076887, 'd13': 0.061169, 'd23': 0.078724},
    ),
    shortDesc = u"""Fitted to 104 distances.
""",
    longDesc = 
u"""
[<Entry index=4 label="C_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=3 label="H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
""",
)

entry(
    index = 108,
    label = "CsjCCC",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    C  ux {1,S}
3    C  ux {1,S}
4    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.068715, 'd13': 0.041315, 'd23': -0.025301},
        uncertainties = {'d12': 0.069579, 'd13': 0.048902, 'd23': 0.079021},
    ),
    shortDesc = u"""Fitted to 103 distances.
""",
    longDesc = 
u"""
[<Entry index=4 label="C_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=77 label="CsCHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=108 label="CsjCCC">]
[<Entry index=79 label="CsCCHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=47 label="C_methyl">, <Entry index=108 label="CsjCCC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=11 label="Ct_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=43 label="C_methane">, <Entry index=108 label="CsjCCC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=108 label="CsjCCC">]
[<Entry index=12 label="Cb_H">, <Entry index=108 label="CsjCCC">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=3 label="H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=108 label="CsjCCC">]
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=108 label="CsjCCC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=108 label="CsjCCC">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=29 label="OOH">, <Entry index=108 label="CsjCCC">]
[<Entry index=78 label="CsOHHH">, <Entry index=108 label="CsjCCC">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=108 label="CsjCCC">]
[<Entry index=82 label="CsCCCH">, <Entry index=108 label="CsjCCC">]
""",
)

entry(
    index = 226,
    label = "Csj/Cs/Cs/Cs",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cs ux {1,S}
4    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.013659, 'd13': 0.028184, 'd23': 0.01222},
        uncertainties = {'d12': 0.08957, 'd13': 0.078259, 'd23': 0.153506},
    ),
    shortDesc = u"""Fitted to 15 distances.
""",
    longDesc = 
u"""
[<Entry index=58 label="O/Cs/H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=4 label="C_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=3 label="H2">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=78 label="CsOHHH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=29 label="OOH">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=12 label="Cb_H">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=226 label="Csj/Cs/Cs/Cs">]
""",
)

entry(
    index = 227,
    label = "Csj/Cs/Cs/Cd",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cs ux {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 228,
    label = "Csj/Cs/Cs/Ct",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cs ux {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 229,
    label = "Csj/Cs/Cs/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cs ux {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 230,
    label = "Csj/Cs/Cd/Cd",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.265941, 'd13': 0.145242, 'd23': -0.123578},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=43 label="C_methane">, <Entry index=230 label="Csj/Cs/Cd/Cd">]
""",
)

entry(
    index = 231,
    label = "Csj/Cs/Cd/Ct",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cd ux {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 232,
    label = "Csj/Cs/Cd/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cd ux {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 233,
    label = "Csj/Cs/Ct/Ct",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 234,
    label = "Csj/Cs/Ct/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Ct u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 235,
    label = "Csj/Cs/Cb/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 236,
    label = "Csj/Cd/Cd/Cd",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Cd ux {1,S}
4    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 237,
    label = "Csj/Cd/Cd/Ct",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Cd ux {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 238,
    label = "Csj/Cd/Cd/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Cd ux {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 239,
    label = "Csj/Cd/Ct/Ct",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 240,
    label = "Csj/Cd/Ct/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Ct u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 241,
    label = "Csj/Cd/Cb/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 242,
    label = "Csj/Ct/Ct/Ct",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Ct u0 {1,S}
3    Ct u0 {1,S}
4    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 243,
    label = "Csj/Ct/Ct/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Ct u0 {1,S}
3    Ct u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 244,
    label = "Csj/Ct/Cb/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Ct u0 {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 245,
    label = "Csj/Cb/Cb/Cb",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cb u0 {1,S}
3    Cb u0 {1,S}
4    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 109,
    label = "CsjCCO",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    C  ux {1,S}
3    C  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.012218, 'd13': -0.105986, 'd23': -0.121529},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
""",
)

entry(
    index = 246,
    label = "Csj/Cs/Cs/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cs ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': 0.012218, 'd13': -0.105986, 'd23': -0.121529},
        uncertainties = {},
    ),
    shortDesc = u"""Fitted to 1 distances.
""",
    longDesc = 
u"""
[<Entry index=3 label="H2">, <Entry index=246 label="Csj/Cs/Cs/O">]
""",
)

entry(
    index = 247,
    label = "Csj/Cs/Cd/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cd ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 248,
    label = "Csj/Cs/Ct/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Ct u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 249,
    label = "Csj/Cs/Cb/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    Cb u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 250,
    label = "Csj/Cd/Cd/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Cd ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 251,
    label = "Csj/Cd/Ct/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Ct u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 252,
    label = "Csj/Cd/Cb/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    Cb u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 253,
    label = "Csj/Ct/Ct/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Ct u0 {1,S}
3    Ct u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 254,
    label = "Csj/Ct/Cb/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Ct u0 {1,S}
3    Cb u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 255,
    label = "Csj/Cb/Cb/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cb u0 {1,S}
3    Cb u0 {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 110,
    label = "CsjCOO",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    C  ux {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 256,
    label = "Csj/Cs/O/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cs ux {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 257,
    label = "Csj/Cd/O/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cd ux {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 258,
    label = "Csj/Ct/O/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Ct u0 {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 259,
    label = "Csj/Cb/O/O",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    Cb u0 {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 111,
    label = "CsjOOO",
    group = 
"""
1 *3 Cs u1 {2,S} {3,S} {4,S}
2    O  ux {1,S}
3    O  ux {1,S}
4    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 34,
    label = "Cdj",
    group = 
"""
1 *3 Cd u1
""",
    distances = DistanceData(
        distances = {'d12': -0.067745, 'd13': 0.015358, 'd23': 0.082294},
        uncertainties = {'d12': 0.073701, 'd13': 0.078757, 'd23': 0.10403},
    ),
    shortDesc = u"""Fitted to 319 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
""",
)

entry(
    index = 70,
    label = "Cdj_CR",
    group = 
"""
1 *3 Cd u1 {2,D}
2    C  ux {1,D}
""",
    distances = DistanceData(
        distances = {'d12': -0.067745, 'd13': 0.015358, 'd23': 0.082294},
        uncertainties = {'d12': 0.073701, 'd13': 0.078757, 'd23': 0.10403},
    ),
    shortDesc = u"""Fitted to 319 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
""",
)

entry(
    index = 112,
    label = "Cdj_CH",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    C  ux {1,D}
3    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.065277, 'd13': 0.012609, 'd23': 0.077335},
        uncertainties = {'d12': 0.078804, 'd13': 0.078528, 'd23': 0.102534},
    ),
    shortDesc = u"""Fitted to 210 distances.
""",
    longDesc = 
u"""
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
""",
)

entry(
    index = 260,
    label = "Cdj_CdsH",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    Cd ux {1,D}
3    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.093854, 'd13': 0.022945, 'd23': 0.115196},
        uncertainties = {'d12': 0.049459, 'd13': 0.084831, 'd23': 0.095394},
    ),
    shortDesc = u"""Fitted to 121 distances.
""",
    longDesc = 
u"""
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=82 label="CsCCCH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=4 label="C_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=3 label="H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=77 label="CsCHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=47 label="C_methyl">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=12 label="Cb_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=29 label="OOH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=78 label="CsOHHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=11 label="Ct_H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=27 label="OHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=79 label="CsCCHH">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=43 label="C_methane">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=260 label="Cdj_CdsH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=260 label="Cdj_CdsH">]
""",
)

entry(
    index = 261,
    label = "Cdj_CddH",
    group = 
"""
1 *3 Cd  u1 {2,D} {3,S}
2    Cdd u0 {1,D}
3    H   u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.026782, 'd13': -0.001313, 'd23': 0.026331},
        uncertainties = {'d12': 0.107829, 'd13': 0.07069, 'd23': 0.113456},
    ),
    shortDesc = u"""Fitted to 89 distances.
""",
    longDesc = 
u"""
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=29 label="OOH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=79 label="CsCCHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=12 label="Cb_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=43 label="C_methane">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=27 label="OHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=3 label="H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=13 label="OradH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=58 label="O/Cs/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=82 label="CsCCCH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=77 label="CsCHHH">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=4 label="C_H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=261 label="Cdj_CddH">]
[<Entry index=78 label="CsOHHH">, <Entry index=261 label="Cdj_CddH">]
""",
)

entry(
    index = 113,
    label = "Cdj_CC",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    C  ux {1,D}
3    C  ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.072645, 'd13': 0.020817, 'd23': 0.092142},
        uncertainties = {'d12': 0.06391, 'd13': 0.080457, 'd23': 0.108515},
    ),
    shortDesc = u"""Fitted to 109 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
""",
)

entry(
    index = 262,
    label = "Cdj_CdsCs",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    Cd ux {1,D}
3    Cs ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.052748, 'd13': 0.01344, 'd23': 0.067639},
        uncertainties = {'d12': 0.061438, 'd13': 0.070549, 'd23': 0.085041},
    ),
    shortDesc = u"""Fitted to 30 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=4 label="C_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=77 label="CsCHHH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=12 label="Cb_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=3 label="H2">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=82 label="CsCCCH">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=11 label="Ct_H">, <Entry index=262 label="Cdj_CdsCs">]
[<Entry index=78 label="CsOHHH">, <Entry index=262 label="Cdj_CdsCs">]
""",
)

entry(
    index = 263,
    label = "Cdj_CdsCd",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    Cd ux {1,D}
3    Cd ux {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.104889, 'd13': 0.031903, 'd23': 0.134137},
        uncertainties = {'d12': 0.077795, 'd13': 0.103835, 'd23': 0.139714},
    ),
    shortDesc = u"""Fitted to 53 distances.
""",
    longDesc = 
u"""
[<Entry index=79 label="CsCCHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=3 label="H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=29 label="OOH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=12 label="Cb_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=47 label="C_methyl">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=4 label="C_H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=82 label="CsCCCH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=43 label="C_methane">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=77 label="CsCHHH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=13 label="OradH">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=58 label="O/Cs/H">, <Entry index=263 label="Cdj_CdsCd">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=263 label="Cdj_CdsCd">]
""",
)

entry(
    index = 264,
    label = "Cdj_CdsCt",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    Cd ux {1,D}
3    Ct u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.028231, 'd13': 0.006171, 'd23': 0.032656},
        uncertainties = {'d12': 0.036727, 'd13': 0.026676, 'd23': 0.060343},
    ),
    shortDesc = u"""Fitted to 26 distances.
""",
    longDesc = 
u"""
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=12 label="Cb_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=29 label="OOH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=77 label="CsCHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=4 label="C_H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=79 label="CsCCHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=3 label="H2">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=78 label="CsOHHH">, <Entry index=264 label="Cdj_CdsCt">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=264 label="Cdj_CdsCt">]
""",
)

entry(
    index = 265,
    label = "Cdj_CdsCb",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    Cd ux {1,D}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 266,
    label = "Cdj_CddCs",
    group = 
"""
1 *3 Cd  u1 {2,D} {3,S}
2    Cdd u0 {1,D}
3    Cs  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 267,
    label = "Cdj_CddCd",
    group = 
"""
1 *3 Cd  u1 {2,D} {3,S}
2    Cdd u0 {1,D}
3    Cd  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 268,
    label = "Cdj_CddCt",
    group = 
"""
1 *3 Cd  u1 {2,D} {3,S}
2    Cdd u0 {1,D}
3    Ct  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 269,
    label = "Cdj_CddCb",
    group = 
"""
1 *3 Cd  u1 {2,D} {3,S}
2    Cdd u0 {1,D}
3    Cb  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 114,
    label = "Cdj_CO",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    C  ux {1,D}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 270,
    label = "Cdj_CdsO",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    Cd ux {1,D}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 271,
    label = "Cdj_CddO",
    group = 
"""
1 *3 Cd  u1 {2,D} {3,S}
2    Cdd u0 {1,D}
3    O   ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 71,
    label = "Cdj_OR",
    group = 
"""
1 *3 Cd u1 {2,D}
2    O  u0 {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 115,
    label = "Cdj_OH",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    O  u0 {1,D}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 116,
    label = "Cdj_OC",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    O  u0 {1,D}
3    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 272,
    label = "Cdj_OCs",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    O  u0 {1,D}
3    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 273,
    label = "Cdj_OCd",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    O  u0 {1,D}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 274,
    label = "Cdj_OCt",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    O  u0 {1,D}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 275,
    label = "Cdj_OCb",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    O  u0 {1,D}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 117,
    label = "Cdj_OO",
    group = 
"""
1 *3 Cd u1 {2,D} {3,S}
2    O  u0 {1,D}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 35,
    label = "Ctj",
    group = 
"""
1 *3 Ct u1
""",
    distances = DistanceData(
        distances = {'d12': -0.230464, 'd13': 0.110987, 'd23': 0.433568},
        uncertainties = {'d12': 0.163555, 'd13': 0.199845, 'd23': 0.199404},
    ),
    shortDesc = u"""Fitted to 12 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=12 label="Cb_H">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
""",
)

entry(
    index = 72,
    label = "CtjC",
    group = 
"""
1 *3 Ct u1 {2,T}
2    C  ux {1,T}
""",
    distances = DistanceData(
        distances = {'d12': -0.230464, 'd13': 0.110987, 'd23': 0.433568},
        uncertainties = {'d12': 0.163555, 'd13': 0.199845, 'd23': 0.199404},
    ),
    shortDesc = u"""Fitted to 12 distances.
""",
    longDesc = 
u"""
[<Entry index=118 label="C/H3/Cs">, <Entry index=72 label="CtjC">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=72 label="CtjC">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=72 label="CtjC">]
[<Entry index=12 label="Cb_H">, <Entry index=72 label="CtjC">]
[<Entry index=82 label="CsCCCH">, <Entry index=72 label="CtjC">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=72 label="CtjC">]
[<Entry index=79 label="CsCCHH">, <Entry index=72 label="CtjC">]
""",
)

entry(
    index = 36,
    label = "Cbj",
    group = 
"""
1 *3 Cb u1
""",
    distances = DistanceData(
        distances = {'d12': -0.095175, 'd13': 0.026648, 'd23': 0.120179},
        uncertainties = {'d12': 0.058676, 'd13': 0.077559, 'd23': 0.092902},
    ),
    shortDesc = u"""Fitted to 44 distances.
""",
    longDesc = 
u"""
[<Entry index=43 label="C_methane">, <Entry index=36 label="Cbj">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=36 label="Cbj">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=36 label="Cbj">]
[<Entry index=27 label="OHH">, <Entry index=36 label="Cbj">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=77 label="CsCHHH">, <Entry index=36 label="Cbj">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=36 label="Cbj">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=79 label="CsCCHH">, <Entry index=36 label="Cbj">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=78 label="CsOHHH">, <Entry index=36 label="Cbj">]
[<Entry index=4 label="C_H">, <Entry index=36 label="Cbj">]
[<Entry index=136 label="C/H/Cs/Cs/Cs">, <Entry index=36 label="Cbj">]
[<Entry index=193 label="Cd_Cdd/H2">, <Entry index=36 label="Cbj">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=36 label="Cbj">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=36 label="Cbj">]
[<Entry index=29 label="OOH">, <Entry index=36 label="Cbj">]
[<Entry index=3 label="H2">, <Entry index=36 label="Cbj">]
[<Entry index=196 label="Cd_Cds/Ct/H">, <Entry index=36 label="Cbj">]
[<Entry index=194 label="Cd_Cds/Cs/H">, <Entry index=36 label="Cbj">]
[<Entry index=82 label="CsCCCH">, <Entry index=36 label="Cbj">]
[<Entry index=11 label="Ct_H">, <Entry index=36 label="Cbj">]
""",
)

entry(
    index = 18,
    label = "Cjj",
    group = "OR{Csjj, Cdjj}",
    distances = DistanceData(
        distances = {'d12': -0.118072, 'd13': 0.037583, 'd23': 0.15275},
        uncertainties = {'d12': 0.049509, 'd13': 0.092401, 'd23': 0.108868},
    ),
    shortDesc = u"""Fitted to 38 distances.
""",
    longDesc = 
u"""
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=3 label="H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 37,
    label = "Csjj",
    group = "OR{Cs_sing, Cs_trip}",
    distances = DistanceData(
        distances = {'d12': -0.118072, 'd13': 0.037583, 'd23': 0.15275},
        uncertainties = {'d12': 0.049509, 'd13': 0.092401, 'd23': 0.108868},
    ),
    shortDesc = u"""Fitted to 38 distances.
""",
    longDesc = 
u"""
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=3 label="H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 73,
    label = "Cs_sing",
    group = 
"""
1 *3 Cs u0 p1
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 284,
    label = "Cs_singH2",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 285,
    label = "Cs_singRH",
    group = 
"""
1 *3 Cs  u0 p1 {2,S} {3,S}
2    H   u0 {1,S}
3    R!H ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 294,
    label = "Cs_singCH",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    H  u0 {1,S}
3    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 304,
    label = "Cs_sing/Cs/H",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    H  u0 {1,S}
3    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 305,
    label = "Cs_sing/Cd/H",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    H  u0 {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 306,
    label = "Cs_sing/Ct/H",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    H  u0 {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 307,
    label = "Cs_sing/Cb/H",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    H  u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 295,
    label = "Cs_singOH",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    H  u0 {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 286,
    label = "Cs_singRR",
    group = 
"""
1 *3 Cs  u0 p1 {2,S} {3,S}
2    R!H ux {1,S}
3    R!H ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 296,
    label = "Cs_singCC",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    C  ux {1,S}
3    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 308,
    label = "Cs_sing/Cs/Cs",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cs ux {1,S}
3    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 309,
    label = "Cs_sing/Cs/Cd",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cs ux {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 310,
    label = "Cs_sing/Cs/Ct",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cs ux {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 311,
    label = "Cs_sing/Cs/Cb",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cs ux {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 312,
    label = "Cs_sing/Cd/Cd",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cd ux {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 313,
    label = "Cs_sing/Cd/Ct",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cd ux {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 314,
    label = "Cs_sing/Cd/Cb",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cd ux {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 315,
    label = "Cs_sing/Ct/Ct",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Ct u0 {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 316,
    label = "Cs_sing/Ct/Cb",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Ct u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 317,
    label = "Cs_sing/Cb/Cb",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cb u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 297,
    label = "Cs_singCO",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    C  ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 318,
    label = "Cs_sing/Cs/O",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cs ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 319,
    label = "Cs_sing/Cd/O",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cd ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 320,
    label = "Cs_sing/Ct/O",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Ct u0 {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 321,
    label = "Cs_sing/Cb/O",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    Cb u0 {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 298,
    label = "Cs_singOO",
    group = 
"""
1 *3 Cs u0 p1 {2,S} {3,S}
2    O  ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 74,
    label = "Cs_trip",
    group = 
"""
1 *3 Cs u2 p0
""",
    distances = DistanceData(
        distances = {'d12': -0.118072, 'd13': 0.037583, 'd23': 0.15275},
        uncertainties = {'d12': 0.049509, 'd13': 0.092401, 'd23': 0.108868},
    ),
    shortDesc = u"""Fitted to 38 distances.
""",
    longDesc = 
u"""
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=3 label="H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 287,
    label = "Cs_tripH2",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    H  u0 {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(
        distances = {'d12': -0.118072, 'd13': 0.037583, 'd23': 0.15275},
        uncertainties = {'d12': 0.049509, 'd13': 0.092401, 'd23': 0.108868},
    ),
    shortDesc = u"""Fitted to 38 distances.
""",
    longDesc = 
u"""
[<Entry index=78 label="CsOHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=58 label="O/Cs/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=118 label="C/H3/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=4 label="C_H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=82 label="CsCCCH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=3 label="H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=132 label="C/H2/Cs/O">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=195 label="Cd_Cds/Cd/H">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=77 label="CsCHHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=119 label="C/H3/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=79 label="CsCCHH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=29 label="OOH">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=122 label="C/H2/Cs/Cs">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=120 label="C/H3/Ct">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=123 label="C/H2/Cs/Cd">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=192 label="Cd_Cds/H2">, <Entry index=287 label="Cs_tripH2">]
[<Entry index=126 label="C/H2/Cd/Cd">, <Entry index=287 label="Cs_tripH2">]
""",
)

entry(
    index = 288,
    label = "Cs_tripRH",
    group = 
"""
1 *3 Cs  u2 p0 {2,S} {3,S}
2    R!H ux {1,S}
3    H   u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 299,
    label = "Cs_tripCH",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    C  ux {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 322,
    label = "Cs_trip/Cs/H",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cs ux {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 323,
    label = "Cs_trip/Cd/H",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cd ux {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 324,
    label = "Cs_trip/Ct/H",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Ct u0 {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 325,
    label = "Cs_trip/Cb/H",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cb u0 {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 300,
    label = "Cs_tripOH",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    O  ux {1,S}
3    H  u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 289,
    label = "Cs_tripRR",
    group = 
"""
1 *3 Cs  u2 p0 {2,S} {3,S}
2    R!H ux {1,S}
3    R!H ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 301,
    label = "Cs_tripCC",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    C  ux {1,S}
3    C  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 326,
    label = "Cs_trip/Cs/Cs",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cs ux {1,S}
3    Cs ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 327,
    label = "Cs_trip/Cs/Cd",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cs ux {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 328,
    label = "Cs_trip/Cs/Ct",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cs ux {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 329,
    label = "Cs_trip/Cs/Cb",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cs ux {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 330,
    label = "Cs_trip/Cd/Cd",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cd ux {1,S}
3    Cd ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 331,
    label = "Cs_trip/Cd/Ct",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cd ux {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 332,
    label = "Cs_trip/Cd/Cb",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cd ux {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 333,
    label = "Cs_trip/Ct/Ct",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Ct u0 {1,S}
3    Ct u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 334,
    label = "Cs_trip/Ct/Cb",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Ct u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 335,
    label = "Cs_trip/Cb/Cb",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cb u0 {1,S}
3    Cb u0 {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 302,
    label = "Cs_tripCO",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    C  ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 336,
    label = "Cs_trip/Cs/O",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cs ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 337,
    label = "Cs_trip/Cd/O",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cd ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 338,
    label = "Cs_trip/Ct/O",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Ct ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 339,
    label = "Cs_trip/Cb/O",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    Cb ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 303,
    label = "Cs_tripOO",
    group = 
"""
1 *3 Cs u2 p0 {2,S} {3,S}
2    O  ux {1,S}
3    O  ux {1,S}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 38,
    label = "Cdjj",
    group = "OR{Cd_singletR, Cd_tripletR}",
    distances = DistanceData(distances={}),
)

entry(
    index = 75,
    label = "Cd_singletR",
    group = 
"""
1 *3 Cd u0 p1
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 290,
    label = "Cd_singletC",
    group = 
"""
1 *3 Cd u0 p1 {2,D}
2    C  ux {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 291,
    label = "Cd_singletO",
    group = 
"""
1 *3 Cd u0 p1 {2,D}
2    O  ux {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 76,
    label = "Cd_tripletR",
    group = 
"""
1 *3 Cd u2 p0
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 292,
    label = "Cd_tripletC",
    group = 
"""
1 *3 Cd u2 p0 {2,D}
2    C  ux {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 293,
    label = "Cd_tripletO",
    group = 
"""
1 *3 Cd u2 p0 {2,D}
2    O  ux {1,D}
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 19,
    label = "Cjjj",
    group = "OR{C_doubletR, C_quartetR}",
    distances = DistanceData(distances={}),
)

entry(
    index = 39,
    label = "C_doubletR",
    group = 
"""
1 *3 C u1 p1
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 40,
    label = "C_quartetR",
    group = 
"""
1 *3 C u3
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 20,
    label = "Cjjjj",
    group = "OR{C_quintet, C_triplet}",
    distances = DistanceData(distances={}),
)

entry(
    index = 41,
    label = "C_quintet",
    group = 
"""
1 *3 C u4 p0
""",
    distances = DistanceData(distances={}),
)

entry(
    index = 42,
    label = "C_triplet",
    group = 
"""
1 *3 C u2 p1
""",
    distances = DistanceData(distances={}),
)

tree(
"""
L1: X_H_or_Xanyrad_H
    L2: H2
    L2: C_H
        L3: Cs_H
            L4: Csnorad_H
                L5: C_methane
                L5: CsRHHH
                    L6: CsCHHH
                        L7: C/H3/Cs
                        L7: C/H3/Cd
                        L7: C/H3/Ct
                        L7: C/H3/Cb
                    L6: CsOHHH
                L5: CsRRHH
                    L6: CsCCHH
                        L7: C/H2/Cs/Cs
                        L7: C/H2/Cs/Cd
                        L7: C/H2/Cs/Ct
                        L7: C/H2/Cs/Cb
                        L7: C/H2/Cd/Cd
                        L7: C/H2/Cd/Ct
                        L7: C/H2/Cd/Cb
                        L7: C/H2/Ct/Ct
                        L7: C/H2/Ct/Cb
                        L7: C/H2/Cb/Cb
                    L6: CsCOHH
                        L7: C/H2/Cs/O
                        L7: C/H2/Cd/O
                        L7: C/H2/Ct/O
                        L7: C/H2/Cb/O
                    L6: CsOOHH
                L5: CsRRRH
                    L6: CsCCCH
                        L7: C/H/Cs/Cs/Cs
                        L7: C/H/Cs/Cs/Cd
                        L7: C/H/Cs/Cs/Ct
                        L7: C/H/Cs/Cs/Cb
                        L7: C/H/Cs/Cd/Cd
                        L7: C/H/Cs/Cd/Ct
                        L7: C/H/Cs/Cd/Cb
                        L7: C/H/Cs/Ct/Ct
                        L7: C/H/Cs/Ct/Cb
                        L7: C/H/Cs/Cb/Cb
                        L7: C/H/Cd/Cd/Cd
                        L7: C/H/Cd/Cd/Ct
                        L7: C/H/Cd/Cd/Cb
                        L7: C/H/Cd/Ct/Ct
                        L7: C/H/Cd/Ct/Cb
                        L7: C/H/Cd/Cb/Cb
                        L7: C/H/Ct/Ct/Ct
                        L7: C/H/Ct/Ct/Cb
                        L7: C/H/Ct/Cb/Cb
                        L7: C/H/Cb/Cb/Cb
                    L6: CsCCOH
                        L7: C/H/Cs/Cs/O
                        L7: C/H/Cs/Cd/O
                        L7: C/H/Cs/Ct/O
                        L7: C/H/Cs/Cb/O
                        L7: C/H/Cd/Cd/O
                        L7: C/H/Cd/Ct/O
                        L7: C/H/Cd/Cb/O
                        L7: C/H/Ct/Ct/O
                        L7: C/H/Ct/Cb/O
                        L7: C/H/Cb/Cb/O
                    L6: CsCOOH
                        L7: C/H/Cs/O/O
                        L7: C/H/Cd/O/O
                        L7: C/H/Ct/O/O
                        L7: C/H/Cb/O/O
                    L6: CsOOOH
            L4: Csrad_H
                L5: C_methyl
                L5: CsradRH2
                    L6: CsradCHH
                        L7: Csrad/H/Cs/H
                        L7: Csrad/H/Cd/H
                        L7: Csrad/H/Ct/H
                        L7: Csrad/H/Cb/H
                    L6: CsradOH2
                L5: CsradRRH
                    L6: CsradCCH
                        L7: Csrad/Cs/Cs/H
                        L7: Csrad/Cs/Cd/H
                        L7: Csrad/Cs/Ct/H
                        L7: Csrad/Cs/Cb/H
                        L7: Csrad/Cd/Cd/H
                        L7: Csrad/Cd/Ct/H
                        L7: Csrad/Cd/Cb/H
                        L7: Csrad/Ct/Ct/H
                        L7: Csrad/Ct/Cb/H
                        L7: Csrad/Cb/Cb/H
                    L6: CsradCOH
                        L7: Csrad/Cs/O/H
                        L7: Csrad/Cd/O/H
                        L7: Csrad/Ct/O/H
                        L7: Csrad/Cb/O/H
                    L6: CsradOOH
            L4: CsbiradH
                L5: Cs_singletH
                    L6: Cs_singletHH
                    L6: Cs_singletRH
                        L7: C_singletCH
                            L8: C_singlet/Cs/H
                            L8: C_singlet/Cd/H
                            L8: C_singlet/Ct/H
                            L8: C_singlet/Cb/H
                        L7: C_singletOH
                L5: Cs_tripletH
                    L6: Cs_tripletHH
                    L6: Cs_tripletRH
                        L7: Cs_tripletCH
                            L8: C_triplet/Cs/H
                            L8: C_triplet/Cd/H
                            L8: C_triplet/Ct/H
                            L8: C_triplet/Cb/H
                        L7: Cs_tripletOH
            L4: CstriradH
                L5: Cdoublet_H
                L5: Cquartet_H
        L3: Cd_H
            L4: Cdnorad_H
                L5: Cd_C/R/H
                    L6: Cd_C/H2
                        L7: Cd_Cds/H2
                        L7: Cd_Cdd/H2
                    L6: Cd_C/C/H
                        L7: Cd_Cds/Cs/H
                        L7: Cd_Cds/Cd/H
                        L7: Cd_Cds/Ct/H
                        L7: Cd_Cds/Cb/H
                        L7: Cd_Cdd/Cs/H
                        L7: Cd_Cdd/Cd/H
                        L7: Cd_Cdd/Ct/H
                        L7: Cd_Cdd/Cb/H
                    L6: Cd_C/O/H
                        L7: Cd_Cds/O/H
                        L7: Cd_Cdd/O/H
                L5: Cd_O/R/H
                    L6: Cd_O/H2
                    L6: Cd_O/C/H
                        L7: Cd_O/Cs/H
                        L7: Cd_O/Cd/H
                        L7: Cd_O/Ct/H
                        L7: Cd_O/Cb/H
                    L6: Cd_O/O/H
            L4: Cdrad_H
                L5: Cdrad_C/H
                    L6: Cdrad_Cds/H
                    L6: Cdrad_Cdd/H
                L5: Cdrad_O/H
        L3: Ct_H
        L3: Cb_H
    L2: O_H
        L3: OradH
        L3: ORH
            L4: OHH
            L4: OCH
                L5: O/Cs/H
                L5: O/Cd/H
                L5: O/Ct/H
                L5: O/Cb/H
            L4: OOH
L1: Y_anyrad
    L2: Hrad
    L2: Orad
        L3: OjR
            L4: OjH
            L4: OjC
                L5: OjCs
                L5: OjCd
                L5: OjCt
                L5: OjCb
            L4: OjO
        L3: O_atom_triplet
    L2: Crad
        L3: Cj
            L4: Csj
                L5: Cs_methyl
                L5: CsjRH2
                    L6: CsjCH2
                        L7: Csj/Cs/H2
                        L7: Csj/Cd/H2
                        L7: Csj/Ct/H2
                        L7: Csj/Cb/H2
                    L6: CsjOH2
                L5: CsjRRH
                    L6: CsjCCH
                        L7: Csj/Cs/Cs/H
                        L7: Csj/Cs/Cd/H
                        L7: Csj/Cs/Ct/H
                        L7: Csj/Cs/Cb/H
                        L7: Csj/Cd/Cd/H
                        L7: Csj/Cd/Ct/H
                        L7: Csj/Cd/Cb/H
                        L7: Csj/Ct/Ct/H
                        L7: Csj/Ct/Cb/H
                        L7: Csj/Cb/Cb/H
                    L6: CsjCOH
                        L7: Csj/Cs/O/H
                        L7: Csj/Cd/O/H
                        L7: Csj/Ct/O/H
                        L7: Csj/Cb/O/H
                    L6: CsjOOH
                L5: CsjRRR
                    L6: CsjCCC
                        L7: Csj/Cs/Cs/Cs
                        L7: Csj/Cs/Cs/Cd
                        L7: Csj/Cs/Cs/Ct
                        L7: Csj/Cs/Cs/Cb
                        L7: Csj/Cs/Cd/Cd
                        L7: Csj/Cs/Cd/Ct
                        L7: Csj/Cs/Cd/Cb
                        L7: Csj/Cs/Ct/Ct
                        L7: Csj/Cs/Ct/Cb
                        L7: Csj/Cs/Cb/Cb
                        L7: Csj/Cd/Cd/Cd
                        L7: Csj/Cd/Cd/Ct
                        L7: Csj/Cd/Cd/Cb
                        L7: Csj/Cd/Ct/Ct
                        L7: Csj/Cd/Ct/Cb
                        L7: Csj/Cd/Cb/Cb
                        L7: Csj/Ct/Ct/Ct
                        L7: Csj/Ct/Ct/Cb
                        L7: Csj/Ct/Cb/Cb
                        L7: Csj/Cb/Cb/Cb
                    L6: CsjCCO
                        L7: Csj/Cs/Cs/O
                        L7: Csj/Cs/Cd/O
                        L7: Csj/Cs/Ct/O
                        L7: Csj/Cs/Cb/O
                        L7: Csj/Cd/Cd/O
                        L7: Csj/Cd/Ct/O
                        L7: Csj/Cd/Cb/O
                        L7: Csj/Ct/Ct/O
                        L7: Csj/Ct/Cb/O
                        L7: Csj/Cb/Cb/O
                    L6: CsjCOO
                        L7: Csj/Cs/O/O
                        L7: Csj/Cd/O/O
                        L7: Csj/Ct/O/O
                        L7: Csj/Cb/O/O
                    L6: CsjOOO
            L4: Cdj
                L5: Cdj_CR
                    L6: Cdj_CH
                        L7: Cdj_CdsH
                        L7: Cdj_CddH
                    L6: Cdj_CC
                        L7: Cdj_CdsCs
                        L7: Cdj_CdsCd
                        L7: Cdj_CdsCt
                        L7: Cdj_CdsCb
                        L7: Cdj_CddCs
                        L7: Cdj_CddCd
                        L7: Cdj_CddCt
                        L7: Cdj_CddCb
                    L6: Cdj_CO
                        L7: Cdj_CdsO
                        L7: Cdj_CddO
                L5: Cdj_OR
                    L6: Cdj_OH
                    L6: Cdj_OC
                        L7: Cdj_OCs
                        L7: Cdj_OCd
                        L7: Cdj_OCt
                        L7: Cdj_OCb
                    L6: Cdj_OO
            L4: Ctj
                L5: CtjC
            L4: Cbj
        L3: Cjj
            L4: Csjj
                L5: Cs_sing
                    L6: Cs_singH2
                    L6: Cs_singRH
                        L7: Cs_singCH
                            L8: Cs_sing/Cs/H
                            L8: Cs_sing/Cd/H
                            L8: Cs_sing/Ct/H
                            L8: Cs_sing/Cb/H
                        L7: Cs_singOH
                    L6: Cs_singRR
                        L7: Cs_singCC
                            L8: Cs_sing/Cs/Cs
                            L8: Cs_sing/Cs/Cd
                            L8: Cs_sing/Cs/Ct
                            L8: Cs_sing/Cs/Cb
                            L8: Cs_sing/Cd/Cd
                            L8: Cs_sing/Cd/Ct
                            L8: Cs_sing/Cd/Cb
                            L8: Cs_sing/Ct/Ct
                            L8: Cs_sing/Ct/Cb
                            L8: Cs_sing/Cb/Cb
                        L7: Cs_singCO
                            L8: Cs_sing/Cs/O
                            L8: Cs_sing/Cd/O
                            L8: Cs_sing/Ct/O
                            L8: Cs_sing/Cb/O
                        L7: Cs_singOO
                L5: Cs_trip
                    L6: Cs_tripH2
                    L6: Cs_tripRH
                        L7: Cs_tripCH
                            L8: Cs_trip/Cs/H
                            L8: Cs_trip/Cd/H
                            L8: Cs_trip/Ct/H
                            L8: Cs_trip/Cb/H
                        L7: Cs_tripOH
                    L6: Cs_tripRR
                        L7: Cs_tripCC
                            L8: Cs_trip/Cs/Cs
                            L8: Cs_trip/Cs/Cd
                            L8: Cs_trip/Cs/Ct
                            L8: Cs_trip/Cs/Cb
                            L8: Cs_trip/Cd/Cd
                            L8: Cs_trip/Cd/Ct
                            L8: Cs_trip/Cd/Cb
                            L8: Cs_trip/Ct/Ct
                            L8: Cs_trip/Ct/Cb
                            L8: Cs_trip/Cb/Cb
                        L7: Cs_tripCO
                            L8: Cs_trip/Cs/O
                            L8: Cs_trip/Cd/O
                            L8: Cs_trip/Ct/O
                            L8: Cs_trip/Cb/O
                        L7: Cs_tripOO
            L4: Cdjj
                L5: Cd_singletR
                    L6: Cd_singletC
                    L6: Cd_singletO
                L5: Cd_tripletR
                    L6: Cd_tripletC
                    L6: Cd_tripletO
        L3: Cjjj
            L4: C_doubletR
            L4: C_quartetR
        L3: Cjjjj
            L4: C_quintet
            L4: C_triplet
"""
)
